<?php
/** @var EventController $this */
/** @var Event $model */
$controller = $this;

$serviceList = CHtml::listData ( Event::getLastServices ( paramdeep ( 'search', 'advanced', 'servicesCount' ) ), 'ID', 'Description' );
$serviceList = array_concat_preserve_keys ( array (
    '' => '-' 
), $serviceList );

$userList = User::getUserFullNameArray ();
$userList = array_concat_preserve_keys ( array (
    '' => '-' 
), $userList );

$resultsList = array (
    '' => '-',
    Event::VALIDATION_RESULT_APPROVED => t ( 'Approved' ),
    Event::VALIDATION_RESULT_INVALID => t ( 'Invalid' ),
    Event::VALIDATION_RESULT_PENDING => t ( 'Pending' ) 
);

$hourList = CHtml::listData ( array_merge ( array (
    array (
        'value' => '',
        'label' => '-' 
    ) 
), DateHelper::hourList () ), 'value', 'label' );

$minuteList = CHtml::listData ( array_merge ( array (
    array (
        'value' => '',
        'label' => '-' 
    ) 
), DateHelper::minuteList () ), 'value', 'label' );

$gateList = Gate::getGateList ();
$gateList = array_concat_preserve_keys ( array (
    '' => '-' 
), $gateList );

$laneList = CHtml::listData ( array (
    array (
        'name' => t ( '-' ),
        'value' => '' 
    ),
    array (
        'name' => t ( '1' ),
        'value' => '0' 
    ),
    array (
        'name' => t ( '2' ),
        'value' => '1' 
    ),
    array (
        'name' => t ( '3' ),
        'value' => '2' 
    ) 
), 'value', 'name' );
?>
<div id='event-search-page'>
  <div class="page-header">
    <h2>
			<?php echo t('Events')?>
		</h2>
  </div>
  <div class="form-box">
    <form id="search-event-form">
      <div class="row">
        <div class="span2">
          <label><?php echo t('License plate'); ?> </label>
          <div class="controls">
						<?php
      if (Yii::app ()->user->checkAccess ( 'license_plate_visibility' ))
        echo "<input type=\"text\" class=\"span2\" name=\"Event[Plate]\" value=\"\" />"?>

					</div>
        </div>

        <div id="date-time-range-search" class="span"
          data-behavior="DateRangeInput"
          data-date-range-start-target='#search-date-start'
          data-date-range-end-target='#search-date-end'>
          <label><?php echo t("Date & Time"); ?> </label>
          <div class="date-time-range-block span">
						<?php echo t("From"); ?>
						<div id="search-date-start"
              class="input-append date datetime-picker">
              <input
                data-format="<?php echo Yii::app()->params['datetimeselect_format'][Yii::app()->language]['view']; ?>"
                type="text" name="Event[event_date_start]"> <span
                class="add-on"> <i data-time-icon="icon-time"
                data-date-icon="icon-calendar"></i>
              </span> </input>
            </div>
          </div>
          <div class="date-time-range-block span">
						<?php echo t("To"); ?>
						<div id="search-date-end"
              class="input-append date datetime-picker">
              <input
                data-format="<?php echo Yii::app()->params['datetimeselect_format'][Yii::app()->language]['view']; ?>"
                type="text" name="Event[event_date_end]; ?>"> <span
                class="add-on"> <i data-time-icon="icon-time"
                data-date-icon="icon-calendar"></i>
              </span> </input>
            </div>
          </div>
        </div>

        <div class="span">
          <label><?php echo t('Speed') ?> </label>
          <div class="controls">
						<?php echo t('From'); ?>
						<?php echo CHtml::ActiveNumberField($model, 'search_speed_start', array('class' => 'span1', 'min' => 0, 'step' => 10)); ?>
						<?php echo t('To'); ?>
						<?php echo CHtml::ActiveNumberField($model, 'search_speed_end', array('class' => 'span1', 'min' => 0, 'step' => 10)); ?>
					</div>
        </div>

        <div class="span">
          <label><?php echo t('Kemler'); ?> </label>
          <div class="controls">
            <input type="text" name="Event[kemlerSearchString]"
              style="width: 100px;" />
          </div>
        </div>

				<?php if(paramdeep('search','advanced','fields','color','show')){ ?>
				<div class="span">
          <label><?php echo t('Color'); ?><a href="#"
            onclick="$('#vehicle_color').val('');$('.colorPicker-picker').css('background-color','white')">[x]</a>
          </label>
          <div class="controls">
						<?php
      $this->widget ( 'ext.colorpicker.ColorPicker', array (
          'name' => 'vehicle_color',
          'options' => array_set_if ( array ( // Optional
              'pickerDefault' => paramdeep ( 'search', 'advanced', 'fields', 'color', 'default' ), // Configuration Object for JS
              'transparency' => true 
          ), is_array ( paramdeep ( 'search', 'advanced', 'fields', 'color', 'colors' ) ), 'colors', paramdeep ( 'search', 'advanced', 'fields', 'color', 'colors' ) ) 
      ) );
      ?>
					</div>
        </div>
				<?php } ?>

			</div>

      <div class="row">

        <div class="span">
          <label><?php echo t('Gate'); ?> </label>
          <div class="controls">
						<?php echo CHtml::activeDropDownList($model, 'Gate', $gateList); ?>
					</div>
        </div>

        <div class="span">
          <label><?php echo t('Lane'); ?> </label>
          <div class="controls">
						<?php echo CHtml::activeDropDownList($model, 'LaneID', $laneList); ?>
					</div>
        </div>

        <div class="span">
          <label><?php echo t('Classe'); ?> </label>
          <div class="controls">
						<?php echo $this->renderPartial('/shared/_vehicleClassSelection', array('selectName'=>'Event[Classe]'), true); ?>
					</div>
        </div>

        <div class="span">
          <label><?php echo t('Nationality'); ?> </label>
          <div class="controls">
						<?php echo $this->renderPartial('/shared/_countrySelection', array('selectName'=>'Event[Nationality]', 'modelName' => 'Event'), true); ?>
					</div>
        </div>

        <div class="span">
          <label><?php echo t('Flags'); ?> </label>
          <div class="controls">
            <input type="hidden" name="searchBookmarked"
              id="searchBookmarked"
              value="<?php echo($model->searchBookmarked ? 1 : 0); ?>" />
            <button class="btn toggleBtn" type="button"
              data-target="#searchBookmarked">
              <i class="icon-bookmark"></i>
            </button>
          </div>
        </div>

      </div>
      <div class="row">

        <div class="span">
          <label><?php echo t('Service'); ?> </label>
          <div class="controls">
            <?php echo CHtml::dropDownList('run_id', '', $serviceList); ?>
          </div>
        </div>

        <div class="span">
          <label><?php echo t('Validation user'); ?> </label>
          <div class="controls">
            <?php echo CHtml::dropDownList('user_id', '', $userList); ?>
          </div>
        </div>

        <div class="span">
          <label><?php echo t('Result'); ?> </label>
          <div class="controls">
            <?php echo CHtml::dropDownList('event_result', '', $resultsList); ?>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="pull-right">
          <input class="btn" type="submit"
            id="search-event-button" value="<?php echo t('Search');?>" />
        </div>
        <?php
        if (Yii::app ()->user->checkAccess ( 'export_events' ))
        {
          ?>
        <div class="pull-right">
          <input class="btn" type="submit"
            id="search-event-button" name="exportbtn"
            value="<?php echo t('Export');?>" />
        </div>
        <?php
        }
        ?>
      </div>

    </form>
  </div>

	<?php

$this->widget ( 'bootstrap.widgets.TbGridView', array (
    // 'template' => '{items}{pager}', //non va bene!
    'id' => 'event-grid',
    'dataProvider' => $model->searchAll (),
    'emptyText' => '',
    'columns' => array (
        array (
            'name' => '',
            'type' => 'html',
            'value' => 'SystemInfoHelper::getEventAlertIcon($data)' 
        ),
        'id_run',
        array (
            'name' => 'Plate',
            'value' => function ($data)
            {
              if (Yii::app ()->user->checkAccess ( 'license_plate_visibility' ))
                return $data->Plate;
              else
                return "#######";
            } 
        ),
        array (
            'name' => 'StartDate',
            'type' => 'raw',
            'value' => function ($data, $row)
            {
              return "<span class='trace-date'>" . DateHelper::formatDate ( $data->StartTime, 'medium' ) . "</span>&nbsp" . "<span class='trace-time'>" . DateHelper::formatTime ( $data->StartTime, 'medium' ) . "</span>";
            },
            'headerHtmlOptions' => array (
                'class' => 'trace-datetime-column' 
            ) 
        ),
        array (
            'name' => 'GateID',
            'value' => '$data->gate->short_name',
            'headerHtmlOptions' => array (
                'class' => 'gate-filter' 
            ) 
        ),
        array (
            'name' => 'Speed',
            'type' => 'raw',
            'value' => '(($data->Speed >= 0)? sprintf("%.1f", $data->Speed) : "-")' 
        ),
        array (
            'name' => 'LaneID',
            'value' => '$data->LaneID + 1' 
        ),
        array (
            'name' => 'Classe',
            'type' => 'raw',
            'value' => function ($data, $row) use($controller)
            {
              return $controller->renderPartial ( '/shared/_vehicleClassBox', array (
                  'event' => $data 
              ), true );
            } 
        ),
        array (
            'name' => 'Nationality',
            'type' => 'raw',
            'value' => function ($data, $row) use($controller)
            {
              return $controller->renderPartial ( '/shared/_countryFlag', array (
                  'isoCode' => $data->nationalityCode 
              ), true );
            } 
        ),
        array (
            'name' => 'kemlerSearchString',
            'value' => function ($data, $row) use($controller)
            {
              return $controller->renderPartial ( '/shared/_kemlerCode', array (
                  'kemlerCode' => $data->kemler 
              ), true );
            },
            'type' => 'raw' 
        ),
        array (
            'header' => t ( 'Colors' ),
            'type' => 'html',
            'value' => 'SystemInfoHelper::getColorSetHtml($data)' 
        ),
        array (
            'header' => t ( 'Actions' ),
            'visible' => (user ()->checkAccess ( 'event_view_all' ) || user ()->checkAccess ( 'verify_events' ) || user ()->checkAccess ( 'check_events_data' ))/* && user()->checkAccess('license_plate_visibility')*/,
      'type' => 'raw',
            'value' => 'SystemInfoHelper::getSingleEventAction($data, ctrl()->getPageLink())' 
        ),
        array (
            // 'visible'=>(user()->checkAccess('verify_events') || user()->checkAccess('check_events_data')) && user()->checkAccess('license_plate_visibility'),
            'header' => t ( 'Status' ),
            'type' => 'raw',
            'value' => 'SystemInfoHelper::getEventStatus($data)' 
        ),
        array (
            'header' => '',
            'type' => 'raw',
            'value' => 'app()->controller->renderBookmark($data,true)' 
        ) 
    ) 
) );
?>
</div>
