<script type="text/javascript" src="../js/columnReorderer.js"></script>
<?php $isBlack = $plateList->mode == PlateList::MODE_BLACK_LIST; ?>
<?php if(Yii::app()->params['listsType']=="black") { ?>
  <?php $isBlack = true; ?>
<?php } ?>
<?php if($isBlack) { ?>
  <script type="text/javascript">
    <?php echo "moveColumn(jQuery('table'), 2, 8);"; ?>
    <?php echo "moveColumn(jQuery('table'), 2, 8);"; ?>
  </script>
<?php } ?>
<?php $liste = array(); ?>
<?php if($plateList == null) { ?>
  <?php $globalMode = true; ?>
  <?php $liste = PlateList::getCurrentUserLists(); ?>
  <?php $liste = array_remap($liste, function($k, $v){ return $v->code; });; ?>
<?php } else { ?>
  <?php $liste[$plateList->code] = $plateList; ?>
<?php } ?>
<?php if (isset($dataProvider) && count($dataProvider->data)>0) { ?>
  <?php $permessi = $dataProvider->data; ?>
  <div class="tableContainer">
    <table class="table table-condensed span12">
      <thead>
        <tr>
          <th></th>
          <th>
            <?php echo htmlspecialchars(t('List'),ENT_QUOTES,'UTF-8'); ?>
          </th>
          <th>
            <?php echo htmlspecialchars(t('Name'),ENT_QUOTES,'UTF-8'); ?>
          </th>
          <th>
            <?php echo htmlspecialchars(t('Surname'),ENT_QUOTES,'UTF-8'); ?>
          </th>
          <th></th>
          <th>
            <?php echo htmlspecialchars(t('Plate'),ENT_QUOTES,'UTF-8'); ?>
          </th>
          <?php if($isBlack)   { ?>
            <th>
              <?php echo htmlspecialchars(t('Model'),ENT_QUOTES,'UTF-8'); ?>
            </th>
            <th>
              <?php echo htmlspecialchars(t('Vehicle class'),ENT_QUOTES,'UTF-8'); ?>
            </th>
            <th>
              <?php echo htmlspecialchars(t('Alert type'),ENT_QUOTES,'UTF-8'); ?>
            </th>
            <th>
              <?php echo htmlspecialchars(t('Notes'),ENT_QUOTES,'UTF-8'); ?>
            </th>
          <?php } ?>
          <?php if(!$isBlack) { ?>
            <th>
              <?php echo htmlspecialchars(t('Gate'),ENT_QUOTES,'UTF-8'); ?>
            </th>
            <th>
              <?php echo htmlspecialchars(t('Time Schedule'),ENT_QUOTES,'UTF-8'); ?>
            </th>
            <th>
              <?php echo htmlspecialchars(t('Start date'),ENT_QUOTES,'UTF-8'); ?>
            </th>
            <th>
              <?php echo htmlspecialchars(t('End date'),ENT_QUOTES,'UTF-8'); ?>
            </th>
            <th>
              <?php echo htmlspecialchars(t('Status'),ENT_QUOTES,'UTF-8'); ?>
            </th>
          <?php } ?>
          <th>
            <?php echo htmlspecialchars(t('Actions'),ENT_QUOTES,'UTF-8'); ?>
          </th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($permessi as $permessoRow) { ?>
          <?php $permesso = $this->createPermessoFromRow($permessoRow, $currentUrl); ?>
          <?php $lista = $liste[$permesso->IDLista]; ?>
          <tr>
            <td>
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($permesso->url_view)), array('title', (t('View')))), 'html5', 'UTF-8'); ?>>
                <i class="icon-eye-open"></i>
              </a>
            </td>
            <td>
              <?php if($permesso->ListaIsBlack) { ?>
                <i class="icon-file-text"></i>
              <?php } else { ?>
                <i class="icon-file-text-alt"></i>
              <?php } ?>
              <?php echo htmlspecialchars($permesso->Lista,ENT_QUOTES,'UTF-8'); ?>
            </td>
            <td>
              <?php if(user()->checkAccess('plate_auth_insert') && user()->checkAccess('plate_auth_insert_wizard')) { ?>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('plateAuthorization/whiteListWizard',array('plateListId'=>$permesso->IDLista,'ownerId'=>$permesso->IDUtente,'step'=>2))))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars($permesso->Nome,ENT_QUOTES,'UTF-8'); ?>
                </a>
              <?php } else { ?>
                <?php echo htmlspecialchars($permesso->Nome,ENT_QUOTES,'UTF-8'); ?>
              <?php } ?>
            </td>
            <td>
              <?php if(user()->checkAccess('plate_auth_insert') && user()->checkAccess('plate_auth_insert_wizard')) { ?>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('plateAuthorization/whiteListWizard',array('plateListId'=>$permesso->IDLista,'ownerId'=>$permesso->IDUtente,'step'=>2))))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars($permesso->Cognome,ENT_QUOTES,'UTF-8'); ?>
                </a>
              <?php } else { ?>
                <?php echo htmlspecialchars($permesso->Cognome,ENT_QUOTES,'UTF-8'); ?>
              <?php } ?>
            </td>
            <td>
              <?php $this->printCountryFlag($permesso->Nationality); ?>
            </td>
            <td>
              <?php if(user()->checkAccess('plate_auth_insert') && user()->checkAccess('plate_auth_insert_wizard')) { ?>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('plateAuthorization/whiteListWizard',array('plateListId'=>$permesso->IDLista,'ownerId'=>$permesso->IDUtente,'vehicleId'=>$permesso->IDVeicolo,'step'=>3))))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars($permesso->Targa,ENT_QUOTES,'UTF-8'); ?>
                </a>
              <?php } else { ?>
                <?php echo htmlspecialchars($permesso->Targa,ENT_QUOTES,'UTF-8'); ?>
              <?php } ?>
            </td>
            <?php if($isBlack) { ?>
              <td>
                <?php echo htmlspecialchars($permesso->DescrizioneVeicolo,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <img <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'vehicle-class-icon-small'), array('src', ((Yii::app()->baseUrl) . '/images/vehicle-classes/' . ($permesso->Classe != "" ? $permesso->Classe : "vehicle") . '.png'))), 'html5', 'UTF-8'); ?> />
              </td>
              <td>
                <?php echo htmlspecialchars($permesso->Categoria,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($permesso->Note,ENT_QUOTES,'UTF-8'); ?>
              </td>
            <?php } ?>
            <?php if(!$isBlack) { ?>
              <td>
                <?php echo SystemInfoHelper::getPlateAuthGateCoolName($permesso->IDGate,$permesso->IDGate_type); ?>
              </td>
              <td>
                <?php echo SystemInfoHelper::getTimeScheduleCoolName($permesso->IDTime); ?>
              </td>
              <td>
                <?php if(user()->checkAccess('plate_auth_insert') && user()->checkAccess('plate_auth_insert_wizard')) { ?>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('plateAuthorization/whiteListWizard',array('plateListId'=>$permesso->IDLista,'ownerId'=>$permesso->IDUtente,'vehicleId'=>$permesso->IDVeicolo,'validityPeriodId'=>$permesso->IDAbbonamento,'step'=>4))))), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars($permesso->DataInizio,ENT_QUOTES,'UTF-8'); ?>
                  </a>
                <?php } else { ?>
                  <?php echo htmlspecialchars($permesso->DataInizio,ENT_QUOTES,'UTF-8'); ?>
                <?php } ?>
              </td>
              <td>
                <?php if(user()->checkAccess('plate_auth_insert') && user()->checkAccess('plate_auth_insert_wizard')) { ?>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('plateAuthorization/whiteListWizard',array('plateListId'=>$permesso->IDLista,'ownerId'=>$permesso->IDUtente,'vehicleId'=>$permesso->IDVeicolo,'validityPeriodId'=>$permesso->IDAbbonamento,'step'=>4))))), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars($permesso->DataFine,ENT_QUOTES,'UTF-8'); ?>
                  </a>
                <?php } else { ?>
                  <?php echo htmlspecialchars($permesso->DataFine,ENT_QUOTES,'UTF-8'); ?>
                <?php } ?>
              </td>
              <td>
                <font <?php echo MtHaml\Runtime::renderAttributes(array(array('color', ($permesso->statusColor))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars($permesso->statusText,ENT_QUOTES,'UTF-8'); ?>
                </font>
              </td>
            <?php } ?>
            <td>
              <?php $this->printPrintBtn($permesso); ?>
              <?php if($lista->editable && Yii::app()->user->checkAccess('plate_auth_enable')) { ?>
                <?php if($permesso->Enabled == 1) { ?>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($permesso->url_revoke)), array('title', (t('Revoke')))), 'html5', 'UTF-8'); ?>>
                    <i class="icon-pause"></i>
                  </a>
                <?php } else { ?>
                  <?php if($lista->editable && Yii::app()->user->checkAccess('plate_auth_activate'))  { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($permesso->url_activate)), array('title', (t('Activate')))), 'html5', 'UTF-8'); ?>>
                      <i class="icon-play"></i>
                    </a>
                  <?php } ?>
                <?php } ?>
              <?php } ?>
              <?php if($lista->editable && $permesso->ToBeConfirmed == 1 && Yii::app()->user->checkAccess('plate_auth_confirmed')) { ?>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($permesso->url_confirm)), array('title', (t('Confirm')))), 'html5', 'UTF-8'); ?>>
                  <i class="icon-unlock-alt"></i>
                </a>
              <?php } ?>
              <?php if($lista->editable && ($permesso->aboutToExpire || $permesso->expired) && Yii::app()->user->checkAccess('plate_auth_renew')) { ?>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($permesso->url_renew)), array('title', (t('Renew')))), 'html5', 'UTF-8'); ?>>
                  <i class="icon-repeat"></i>
                </a>
              <?php } ?>
              <?php if($lista->editable && Yii::app()->user->checkAccess('plate_auth_delete')) { ?>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($permesso->url_delete)), array('title', (t('Delete'))), array('onclick', ('return confirm(\'' . (t('Are you sure you want to delete this item?')) . '\')'))), 'html5', 'UTF-8'); ?>>
                  <i class="icon-trash"></i>
                </a>
              <?php } ?>
            </td>
          </tr>
        <?php } ?>
      </tbody>
    </table>
  </div>
  <?php if (isset($dataProvider->pagination)) { ?>
    <div class="pagination pagination-links-container">
      <?php $this->widget('bootstrap.widgets.TbPager', array('pages' => $dataProvider->pagination)); ?>
    </div>
    <?php echo htmlspecialchars(t("Results").": $totalResults",ENT_QUOTES,'UTF-8'); ?>
  <?php } ?>
<?php } else { ?>
  <h4><?php echo htmlspecialchars(Yii::t("app", "No results"),ENT_QUOTES,'UTF-8'); ?></h4>
<?php } ?>
