<?php if(!isset(Yii::app()->params['eventsToShow']) || Yii::app()->params['eventsToShow']!=="alarm") { ?>
  <h3><?php echo htmlspecialchars(t('Last alerts'),ENT_QUOTES,'UTF-8'); ?></h3>
<?php } else { ?>
  <h3><?php echo htmlspecialchars(t('Last alarms')  ,ENT_QUOTES,'UTF-8'); ?></h3>
<?php } ?>
<header>
  <div class="row clearfix">
    <div class="span5">
      <div class="gate-description">
        <?php if(isset($gate)) { ?>
          <p class="gate-name">
            <i class="icon-road"></i>
            <?php echo htmlspecialchars($gate->Descrizione,ENT_QUOTES,'UTF-8'); ?>
          </p>
        <?php } else { ?>
          <p class="gate-name"><?php echo htmlspecialchars(t('All gates selected'),ENT_QUOTES,'UTF-8'); ?></p>
        <?php } ?>
        <p class="update-time">
          <?php echo htmlspecialchars(t("Updated at:"),ENT_QUOTES,'UTF-8'); ?>
          <?php echo htmlspecialchars(DateHelper::formatLocalDateTime(),ENT_QUOTES,'UTF-8'); ?>
        </p>
      </div>
    </div>
    <div class="span3 pull-right">
      <div class="update-controls">
        <form class="form-inline">
          <label class="checkbox">
            <input class="automatic-alerts-preview" type="checkbox" checked="checked"><?php echo htmlspecialchars(t('Automatic update'),ENT_QUOTES,'UTF-8'); ?></input>
          </label>
          <button class="update-alerts-preview btn btn-small" type="button"><?php echo htmlspecialchars(t('Update'),ENT_QUOTES,'UTF-8'); ?></button>
        </form>
      </div>
    </div>
  </div>
</header>
<article class="alerts">
  <?php if (is_null($alerts)) { ?>
    test
  <?php } else { ?>
    <?php if (count($alerts)>0) { ?>
      <table class="table table-condensed">
        <thead>
          <tr>
            <th></th>
            <th><?php echo htmlspecialchars(t('Event type'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Gate'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Date'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Time'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Km/h'),ENT_QUOTES,'UTF-8'); ?></th>
            <?php if(!isset(Yii::app()->params['eventsToShow']) || Yii::app()->params['eventsToShow']!=="alarm") { ?>
              <th><?php echo htmlspecialchars(t('Kemler'),ENT_QUOTES,'UTF-8'); ?></th>
            <?php } ?>
            <th><?php echo htmlspecialchars(t('Class'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Colors'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('License plate'),ENT_QUOTES,'UTF-8'); ?></th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($alerts as $alert) { ?>
            <?php $alertPresenter = new AlertPresenter($alert);; ?>
            <?php $this->renderPartial('alerts/_alertRow', array('alert' => $alertPresenter)); ?>
          <?php } ?>
        </tbody>
      </table>
    <?php } else                 { ?>
      <div class="spinner">
        <div class="bounce1"></div>
        <div class="bounce2"></div>
        <div class="bounce3"></div>
      </div>
    <?php } ?>
  <?php } ?>
</article>
<div id="modal-alert-photo-preview"></div>
