<?php $alertP = new AlertPresenter($alert); ?>
<?php $vehicleMatches = $alertP->blacklistVehicleMatches; ?>
<div id="alert-view">
  <div class="page-header">
    <div class="row clearfix">
      <div class="span8">
        <h2>
          <?php echo htmlspecialchars(t('Alert - Event detail'),ENT_QUOTES,'UTF-8'); ?>
        </h2>
      </div>
      <?php if(Yii::app()->user->checkAccess('export_pdf')) { ?>
        <div class="span2 pull-right text-right">
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('href', (Yii::app()->createAbsoluteUrl('alert/exportPdf', array('id' => $alert->id)))), array('target', ('_blank'))), 'html5', 'UTF-8'); ?>>
            <?php echo htmlspecialchars(t('Export'),ENT_QUOTES,'UTF-8'); ?>
          </a>
        </div>
      <?php } ?>
    </div>
  </div>
  <div class="row">
    <div class="span4">
      <?php if(Yii::app()->user->checkAccess('media_view_video')) { ?>
        <?php if(!empty($event->video_file_name)) { ?>
          <center>
            <?php $this->renderVideo($event->getVideoUrl(), 350); ?>
          </center>
        <?php } ?>
      <?php } ?>
      <div id="etalage-container" data-behavior="MediaEtalage">
        <ul id="etalage">
          <?php if(Yii::app()->user->checkAccess('media_view_photo')) { ?>
            <?php foreach ($event->photosUrl as $url) { ?>
              <li>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $url)), 'html5', 'UTF-8'); ?>>
                  <img <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'etalage_source_image'), array('src', $url), array('alt', '')), 'html5', 'UTF-8'); ?> />
                </a>
              </li>
            <?php } ?>
          <?php } ?>
        </ul>
      </div>
    </div>
    <div class="span8">
      <div <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'event-data'), array('data-behavior', ('nuclearifyAlertView')), array('data-alert-id', ($alert->id))), 'html5', 'UTF-8'); ?>>
        <div class="row">
          <?php $form = $this->beginWidget('bootstrap.widgets.TbActiveForm',array('type' => 'horizontal','action' => array('/alert/update/'.$alert->id),'htmlOptions' => array('id' => 'alert-form'),)); ?>
          <div class="span4">
            <fieldset>
              <?php if(isset($editEnable) && $editEnable) { ?>
                <?php $this->renderPartial('/alert/_vehicleTraceDetails', array('event' => $event, 'form' => $form)); ?>
              <?php } else { ?>
                <?php $this->renderPartial('/alert/_vehicleTraceDetails', array('event' => $event)); ?>
              <?php } ?>
            </fieldset>
          </div>
          <div class="span4">
            <fieldset>
              <?php if(isset($editEnable) && $editEnable) { ?>
                <?php $this->renderPartial('/alert/_alertDetails', array('alert' => $alert, 'form' => $form)); ?>
              <?php } else { ?>
                <?php $this->renderPartial('/alert/_alertDetails', array('alert' => $alert)); ?>
              <?php } ?>
            </fieldset>
            <?php if(sizeof($vehicleMatches) > 0) { ?>
              <div class="blacklist-links">
                <h4><?php echo htmlspecialchars(t("Blacklist matches"),ENT_QUOTES,'UTF-8'); ?></h4>
                <div class="span">
                  <?php foreach($vehicleMatches as $vehicleMatch) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($this->createUrl('PlateAuthorization/viewByVehicle', array('id'=>$vehicleMatch)))), array('target', '_blank')), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars("#{$vehicleMatch}",ENT_QUOTES,'UTF-8'); ?></a>
                    <br />
                  <?php } ?>
                </div>
              </div>
            <?php } ?>
          </div>
        </div>
        <div class="row">
          <?php if(user()->checkAccess('alert_take_charge')) { ?>
            <div class="span8 text-right">
              <fieldset>
                <?php if(isset($editEnable) && $editEnable) { ?>
                  <button <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'save-alert'), array('class', 'btn'), array('type', 'submit'), array('data-confirm-text', (t('Confirm')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(t('Save & Close'),ENT_QUOTES,'UTF-8'); ?></button>
                <?php } else if(!$alert->isManaged()) { ?>
                  <button <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'take-charge'), array('class', 'btn'), array('type', 'button'), array('data-confirm-text', (t('Confirm')))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(t('Take Charge'),ENT_QUOTES,'UTF-8'); ?></button>
                <?php } ?>
              </fieldset>
            </div>
          <?php } ?>
        </div>
        <?php $this->endWidget(); ?>
        <form <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'take-charge-form'), array('class', 'hidden'), array('action', ($this->createUrl('alert/takeCharge', array('id'=>$alert->id)))), array('method', 'POST')), 'html5', 'UTF-8'); ?>></form>
      </div>
    </div>
  </div>
  <div id="overlay">
    <div id="modal-image"></div>
  </div>
</div>
