<div id="special-day-index-page">
  <div class="page-header">
    <h2>
      <li class="icon-cog"></li>
      <?php echo htmlspecialchars(Yii::t("app", "Special Days"),ENT_QUOTES,'UTF-8'); ?>
    </h2>
  </div>
  <div class="row">
    <?php $specialDays = $dataProvider->data; ?>
    <div class="tableContainer pagination-data-container">
      <table class="table table-condensed span12">
        <thead>
          <tr></tr>
          <tr>
            <th><?php echo htmlspecialchars(t('ID'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Name'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Description'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Date'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Creation date'),ENT_QUOTES,'UTF-8'); ?></th>
            <th>
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-mini')), array('href', (Yii::app()->createAbsoluteUrl('specialDay/create')))), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars(Yii::t('app', 'New special day')   ,ENT_QUOTES,'UTF-8'); ?>
              </a>
            </th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($specialDays as $specialDay) { ?>
            <tr>
              <td>
                <?php echo htmlspecialchars($specialDay->id,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($specialDay->name,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($specialDay->description,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($specialDay->day,ENT_QUOTES,'UTF-8'); ?>
                <?php echo htmlspecialchars(DateHelper::getMonthName($specialDay->month),ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars(DateHelper::formatMedium($specialDay->epoch),ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <div class="btn-group">
                  <a class="btn btn-small dropdown-toggle" data-toggle="dropdown" href="#">
                    <?php echo htmlspecialchars(Yii::t("app", "Actions"),ENT_QUOTES,'UTF-8'); ?>
                    <span class="caret"></span>
                  </a>
                  <ul class="dropdown-menu pull-right">
                    <li>
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('specialDay/update', array('id' => $specialDay->id))))), 'html5', 'UTF-8'); ?>>
                        <?php echo htmlspecialchars(Yii::t("app", ("Modify")),ENT_QUOTES,'UTF-8'); ?>
                      </a>
                    </li>
                    <li>
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('specialDay/delete', array('id' => $specialDay->id))))), 'html5', 'UTF-8'); ?>>
                        <?php echo htmlspecialchars(Yii::t("app", ("Delete"))   ,ENT_QUOTES,'UTF-8'); ?>
                      </a>
                    </li>
                  </ul>
                </div>
              </td>
            </tr>
          <?php } ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
