<?php $canEdit = $this->canEdit(); ?>
<div id="service-page">
  <?php $user = User::model()->findByPk(Yii::app()->user->id); ?>
  <div class="page-header">
    <h2><?php echo htmlspecialchars(Yii::t("app", "Tasks"),ENT_QUOTES,'UTF-8'); ?></h2>
  </div>
  <div id="services-summary" class="well">
    <?php $this->renderPartial("_servicesSummary", get_defined_vars()); ?>
  </div>
  <div class="alert alert-info">
    <span style="padding-right: 10px;">
      <?php echo htmlspecialchars(t("Available Filters"),ENT_QUOTES,'UTF-8'); ?>
    </span>
    <span>
      <?php if($canEdit) { ?>
        <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('id', 'release-all'), array('data-confirm-text', (Yii::t('app', 'Confirm?')))), 'html5', 'UTF-8'); ?>>
          <?php echo htmlspecialchars(Yii::t("app", "Release All Tasks"),ENT_QUOTES,'UTF-8'); ?>
        </button>
      <?php } ?>
      <?php $bfilter = false;; ?>
      <?php if(user()->checkAccess('service_can_filter_only_with_events')) { ?>
        <a class="btn" href="service?onlyWithEvents=1"><?php echo htmlspecialchars(t('Only With Events'),ENT_QUOTES,'UTF-8'); ?></a>
        <?php $bfilter = true;  ; ?>
      <?php } ?>
      <?php if(user()->checkAccess('service_can_filter_mine')) { ?>
        <a class="btn" href="service?mine=1"><?php echo htmlspecialchars(t('In Charge To Me')      ,ENT_QUOTES,'UTF-8'); ?></a>
        <?php $bfilter = true;  ; ?>
      <?php } ?>
      <?php if(user()->checkAccess('service_can_filter_to_be_validated') && !paramdeep('report','byWorkPeriod')) { ?>
        <a class="btn" href="service?tobevalidated=1"><?php echo htmlspecialchars(t('To Be Validated'),ENT_QUOTES,'UTF-8'); ?></a>
        <?php $bfilter = true; ; ?>
      <?php } ?>
      <?php if(user()->checkAccess('service_can_filter_validating_all')  && !paramdeep('report','byWorkPeriod')) { ?>
        <a class="btn" href="service?validating_all=1"><?php echo htmlspecialchars(t('Validating'),ENT_QUOTES,'UTF-8'); ?></a>
        <?php $bfilter = true;  ; ?>
      <?php } else if(user()->checkAccess('service_can_filter_validating')  && !paramdeep('report','byWorkPeriod')) { ?>
        <a class="btn" href="service?validating=1"><?php echo htmlspecialchars(t('Validating'),ENT_QUOTES,'UTF-8'); ?></a>
        <?php $bfilter = true; ; ?>
      <?php } ?>
      <?php if(user()->checkAccess('service_can_filter_exported_all') && !paramdeep('report','byWorkPeriod')) { ?>
        <a class="btn" href="service?exported_all=1"><?php echo htmlspecialchars(t('Exported'),ENT_QUOTES,'UTF-8'); ?></a>
        <?php $bfilter = true;        ; ?>
      <?php } else if(user()->checkAccess('service_can_filter_exported') && !paramdeep('report','byWorkPeriod')) { ?>
        <a class="btn" href="service?exported=1"><?php echo htmlspecialchars(t('Exported')      ,ENT_QUOTES,'UTF-8'); ?></a>
        <?php $bfilter = true;       ; ?>
      <?php } ?>
      <?php if($bfilter) { ?>
        <a class="btn" href="service?allServices"><?php echo htmlspecialchars(t('All')      ,ENT_QUOTES,'UTF-8'); ?></a>
        <a class="btn" href="service"><?php echo htmlspecialchars(t('Validable')      ,ENT_QUOTES,'UTF-8'); ?></a>
      <?php } ?>
    </span>
  </div>
  <div id="services-partial" data-behavior="SlidePagination" style="padding-bottom: 40px;">
    <?php $this->renderPartial('_servicesTable', get_defined_vars()); ?>
  </div>
  <div id="modal-report-confirm" class="modal hide fade"></div>
</div>
