<?php

/**
 * @property integer UserId
 * @property string note
 * @property boolean services_exclude_empty
 */
class UserSettingsManager
{
  /**
   * @var UserSettingsInfo[]
   */
  private $_keys = array();  
    
  /**
   * @var integer
   */
  private $_userId;

  /**
   * @param integer $uid
   */
  public function __construct($uid = null)
  {
    if($uid == null)
      $uid = Yii::app()->user->id;
    $this->_userId = $uid;
    
    $this->_keys[] = new UserSettingsInfo('UserId', 'integer', t('TEST'), t('User ID'));
    
    $this->_keys[] = new UserSettingsInfo('services_exclude_empty', 'boolean', t('Services'), t('Exclude empty services'));
    $this->services_exclude_empty = false;
    
    $this->_keys[] = new UserSettingsInfo('note', 'string', t('Others'), t('Note'));
    $this->note = '';
  }
  
  /**
   * @param string $property
   * @param mixed $value
   * @return boolean
   */
  public function __set($property, $value)
  {
    if($property == 'UserId')
    {
      $this->_userId = intval($value);
      return true;
    }
    return UserSettings::setValueForUser($this->_userId, $property, serialize($value));
  }
  
  /**
   * @return UserSettingsInfo[]
   */
  public function getKeys()
  {
    return $this->_keys;
  }

  /**
   * 
   * @param string $property
   * @return mixed
   */
  public function __get($property)
  {
    if($property == 'UserId')
    {
      return $this->_userId;
    }
    $item = UserSettings::getValueForUser($this->_userId, $property);
    return $item != null
      ? unserialize($item->value)
      : null
    ;
  }
}
