<?php

/**
 * This is the model class for table "onu_code".
 *
 * The followings are the available columns in table 'adr_code':
 * @property integer $id                Chiave primaria record
 * @property string  $code              ONU code
 * @property string  $description       description
 */

class OnuCode extends ActiveRecord
{


  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }

  public function tableName()
  {
    return 'onu_code';
  }

  public function relations()
  {
    return array(
    );
  }

  public function scopes()
  {
    return array(
    );
  }

  public function defaultScope()
  {
    $alias = $this->getTableAlias(false, false);
    return array('order' => "ABS($alias.code) ASC");
  }

  public function byCode($code)
  {
    $this->getDbCriteria()->mergeWith(array(
      'condition' => 'code = :code',
      'params' => array(':code' => $code),
    ));
    return $this;
  }


  public function selectCode()
  {
    $this->getDbCriteria()->mergeWith(array(
      'select' => array('code')
    ));
    return $this;
  }
};
